// Copyright (c) Microsoft Corporation. All rights reserved.

// Called by PREPROCESS_FUNCTION in VC7\VCProjects\ATLWiz.vsz
function CheckATLProjectName(selProj, selObj)
{
    var strProjectName = wizard.FindSymbol("PROJECT_NAME");
    if (strProjectName.toLowerCase() == "compreg")
    {
        var L_NameNotAllowed_Text = "This project name is not allowed. Please chose another one."
        wizard.ReportError(L_NameNotAllowed_Text);
        return false;
    }
    return true;
}

function OnFinish(selProj, selObj)
{
    try
    {
        var strTemplatePath = wizard.FindSymbol("TEMPLATES_PATH");
        var strProjectPath  = wizard.FindSymbol("PROJECT_PATH");
        var strProjectName  = wizard.FindSymbol("PROJECT_NAME");

        wizard.AddSymbol("RC_FILE_NAME",CreateSafeRCFileName(strProjectName)+".rc");
        wizard.AddSymbol("SAFE_PROJECT_APPID_NAME", wizard.FindSymbol("SAFE_PROJECT_IDENTIFIER_NAME"));
        wizard.AddSymbol("SAFE_IDL_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
        selProj = CreateProject(strProjectName, strProjectPath);

        AddConfigurations(selProj, strProjectName);
        StampWindowsTargetPlatformVersion(selProj);
        SetupFilters(selProj);
        selProj.Object.keyword = "AtlProj";

        AddFilesToProjectWithInfFile(selProj, strProjectName);

        var L_strGenerated_Text = "ɵļ";
        var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");

        var strMIDLHeader = strProjectPath + "\\" + strIdlName + "_i.h";
        wizard.RenderTemplate(strTemplatePath + "\\root_i.h", strMIDLHeader, true);

        var strMIDL_IFile = strProjectPath + "\\" + strIdlName + "_i.c";
        wizard.RenderTemplate(strTemplatePath + "\\root_i.c", strMIDL_IFile, true);

        var oGeneratedFiles = selProj.Object.AddFilter(L_strGenerated_Text);
        if (oGeneratedFiles)
        {
            oGeneratedFiles.SourceControlFiles = false;
            oGeneratedFiles.AddFile(strMIDLHeader);
            oGeneratedFiles.AddFile(strMIDL_IFile);
        }
        else
        {
            selProj.Object.AddFile(strMIDLHeader);
            selProj.Object.AddFile(strMIDL_IFile);
        }

        if (!wizard.FindSymbol("GENERATE_ATL_DOCUMENT"))
        {
            // Add existing items (links) from MFC project handlers are being added for.
            // Add the document h/cpp, view h.cpp, and cntritem h/cpp (if exist).
            oFSO = new ActiveXObject("Scripting.FileSystemObject");

            var strMFCDocHeader = wizard.FindSymbol("DOCUMENT_HEADER_FILENAME_TRIMMED");
            if (strMFCDocHeader != "")
            {
                var strFile;

                strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCDocHeader);
                if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCDocHeader))
                {
                    selProj.Object.AddFile(strMFCDocHeader);
                }

                var strMFCDocImpl = strMFCDocHeader.substring(0, strMFCDocHeader.length - 1) + "cpp";
                strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCDocImpl);
                if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCDocImpl))
                {
                    selProj.Object.AddFile(strMFCDocImpl);
                }

                var strMFCViewHeader = wizard.FindSymbol("VIEW_HEADER_FILENAME_TRIMMED");
                if (strMFCViewHeader != "")
                {
                    strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCViewHeader);
                    if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCViewHeader))
                    {
                        selProj.Object.AddFile(strMFCViewHeader);
                    }

                    var strMFCViewImpl = strMFCViewHeader.substring(0, strMFCViewHeader.length - 1) + "cpp";
                    strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCViewImpl);
                    if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCViewImpl))
                    {
                        selProj.Object.AddFile(strMFCViewImpl);
                    }
                }

                var nLength = strMFCDocHeader.length;
                var nEndIndex = nLength - 1;
                while (nEndIndex > 0 && (strMFCDocHeader.charAt(nEndIndex) != '\\'))
                {
                    nEndIndex--;
                }

                var strMFCCntrHeader = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.h";
                strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCCntrHeader);
                if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCCntrHeader))
                {
                    selProj.Object.AddFile(strMFCCntrHeader);

                    var strMFCCntrImpl = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.cpp";
                    strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCCntrImpl);
                    if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCCntrImpl))
                    {
                        selProj.Object.AddFile(strMFCCntrImpl);
                    }
                }
            }
        }

        // Set special flags on the MIDL-generated .c file
        var projfile = selProj.Object.Files(strIdlName + "_i.c");
        if (projfile != null) {
            projfile = projfile.Object;
            SetFileProperties(projfile, strIdlName + "_i.c");
        }

        SetPchSettings(selProj, strProjectName);

        var Sdl = wizard.FindSymbol("SDL_CHECK");

        if (Sdl)
        {
            EnableSDLCheckSettings(selProj);
        }

        selProj.Object.Save();

        var bMergeProxy = wizard.FindSymbol("MERGE_PROXY_STUB");
        if (!bMergeProxy)
        {
            var strDefFile = strProjectPath + "\\" + strProjectName + "ps.def";
            var str_PFile;
            var str_IFile;

            str_PFile = strProjectPath + "\\" + strIdlName + "_p.c";
            str_IFile = strProjectPath + "\\" + strIdlName + "_i.c";

            strProjectName += "PS";
            wizard.AddSymbol("CLOSE_SOLUTION", false);
            var oPSProj = CreateProject(strProjectName, strProjectPath);

            SetPSConfigurations(oPSProj, selProj);

            var strSrcFilter = wizard.FindSymbol("SOURCE_FILTER");
            var L_Source_Text = "Դļ";
            var group = oPSProj.Object.AddFilter(L_Source_Text);
            group.Filter = strSrcFilter;

            oPSProj.Object.keyword = "AtlPSProj";

            wizard.RenderTemplate(strTemplatePath + "\\rootps.def", strDefFile);
            oPSProj.Object.AddFile(strDefFile);
            var oGeneratedFiles = oPSProj.Object.AddFilter(L_strGenerated_Text);
            if (oGeneratedFiles)
            {
                oGeneratedFiles.SourceControlFiles = false;
                oGeneratedFiles.AddFile(str_IFile);
                oGeneratedFiles.AddFile(str_PFile);
                oGeneratedFiles.AddFile(strProjectPath + "\\dlldata.c");
            }
            else
            {
                oPSProj.Object.AddFile(str_IFile);
                oPSProj.Object.AddFile(str_PFile);
                oPSProj.Object.AddFile(strProjectPath + "\\dlldata.c");
            }
            // Set special flags on the MIDL-generated .c file
            var projfile = selProj.Object.Files(strIdlName + "_p.c");
            if (projfile != null) {
                projfile = projfile.Object;
                SetFileProperties(projfile, strIdlName + "_p.c");
            }
            projfile = selProj.Object.Files(strIdlName + "_c.c");
            if (projfile != null) {
                projfile = projfile.Object;
                SetFileProperties(projfile, strIdlName + "_c.c");
            }
            projfile = selProj.Object.Files("dlldata.c");
            if (projfile != null) {
                projfile = projfile.Object;
                SetFileProperties(projfile, "dlldata.c");
            }

            oPSProj.Object.Save();
        }

        // expand main project node, highlight it
        //
        strProjectName  = wizard.FindSymbol("PROJECT_NAME");
        var oHier = wizard.dte.Windows.Item(vsWindowKindSolutionExplorer).Object;
        var oHISolution = oHier.UIHierarchyItems(1);
        var oHIProjMain;
        for (nHI=1; nHI<=oHISolution.UIHierarchyItems.Count; nHI++)
        {
            if ( oHISolution.UIHierarchyItems(nHI).name == strProjectName )
            {
                oHIProjMain = oHISolution.UIHierarchyItems(nHI);
                break;
            }
        }
        if (oHIProjMain)
        {
            oHIProjMain.UIHierarchyItems.Expanded = true;
            oHIProjMain.Select(vsUISelectionTypeSelect);
        }
    }
    catch(e)
    {
        if (e.description.length != 0)
            SetErrorInfo(e);
        return e.number
    }
}

function SetFileProperties(projfile, strName)
{
    if (strName == "dllmain.cpp" || strName.substr(strName.length-2,strName.length) == ".c") {
        var Configs = projfile.Object.FileConfigurations;
        for(var i=1;i<=Configs.Count;++i) {
            var Config = Configs(i);
            var CLTool = Config.Tool;
            CLTool.CompileAsManaged = 0; // Force no /CLR
            CLTool.UsePrecompiledHeader  = 0; // No pre-compiled headers
        }
    }
}

function GetTargetName(strName, strProjectName, strResPath, strHelpPath)
{
    try
    {
        var strTarget = strName;

        if (strName.substr(0, 4) == "root")
        {
            if (strName == "root.idl")
            {
                var strProjectName = wizard.FindSymbol("SAFE_IDL_NAME");
                strTarget = strProjectName + ".idl";
            }
            else if (strName == "root.rc")
            {
                strTarget = wizard.FindSymbol("RC_FILE_NAME");
            }
            else
            {
                strTarget = strProjectName + strName.substr(4);
            }

            return strTarget;
        }

        switch (strName)
        {
            case "readme.txt":
                strTarget = "ReadMe.txt";
                break;
            case "resource.h":
                strTarget = "Resource.h";
                break;
            case "document.cpp":
                strTarget = wizard.FindSymbol("DOCUMENT_IMPL_FILENAME_TRIMMED");
                break;
            case "document.h":
                strTarget = wizard.FindSymbol("DOCUMENT_HEADER_FILENAME_TRIMMED");
                break;
            case "Preview.h":
                strTarget = "PreviewHandler.h";
                break;
            case "Preview.rgs":
                strTarget = "PreviewHandler.rgs";
                break;
            case "Thumbnail.h":
                strTarget = "ThumbnailHandler.h";
                break;
            case "Thumbnail.rgs":
                strTarget = "ThumbnailHandler.rgs";
                break;
            case "Search.h":
                strTarget = "FilterHandler.h";
                break;
            case "Search.rgs":
                strTarget = "FilterHandler.rgs";
                break;
            default:
                break;
        }

        return strTarget;
    }
    catch(e)
    {
        throw e;
    }
}

function SetPSConfigurations(oProj, oMainProj)
{
    try
    {
        oConfigs = oProj.Object.Configurations;
        bSupportComPlus = wizard.FindSymbol("SUPPORT_COMPLUS");

        for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
        {
            var oConfig = oConfigs(nCntr);
            var bDebug = false;
            if (-1 != oConfig.Name.indexOf("Debug"))
                bDebug = true;

            oConfig.IntermediateDirectory = "$(Configuration)PS\\";
            oConfig.ConfigurationType = typeDynamicLibrary;
            oConfig.CharacterSet = charSetUNICODE;
            var oCLTool = oConfig.Tools("VCCLCompilerTool");

            var strDefines = oCLTool.PreprocessorDefinitions;
            if (strDefines != "") strDefines += ";";
            strDefines += GetPlatformDefine(oConfig);
            strDefines += "REGISTER_PROXY_DLL";
            if (bDebug)
            {
                strDefines += ";_DEBUG";
            }
            else
            {
                strDefines += ";NDEBUG";
                oCLTool.Optimization = optimizeMaxSpeed;
            }
            oCLTool.PreprocessorDefinitions = strDefines;

            var oLinkTool = oConfig.Tools("VCLinkerTool");
            oLinkTool.AdditionalDependencies = "kernel32.lib rpcns4.lib rpcrt4.lib oleaut32.lib uuid.lib";

            if (bSupportComPlus)
                oLinkTool.AdditionalDependencies += " ole32.lib advapi32.lib comsvcs.lib";

            oLinkTool.ModuleDefinitionFile = oProj.Name + ".def";

            if (!bDebug)
            {
                oLinkTool.EnableCOMDATFolding = optFolding;
                oLinkTool.OptimizeReferences = optReferences;
            }

            oLinkTool.RegisterOutput = true;

            var oPreBuildTool = oConfig.Tools("VCPreBuildEventTool");
            var strCommand = "if exist dlldata.c goto :END\r\n";
            var L_Echo1_Text = "Echo : MIDL  DLLDATA.CĿ 1 ӿڡ\r\n";
            strCommand += L_Echo1_Text;
            strCommand += "Exit 1\r\n";
            strCommand += ":END\r\n";
            oPreBuildTool.CommandLine = strCommand;
            var L_Echo2_Text = "Ƿļ";
            oPreBuildTool.Description = L_Echo2_Text;
        }

        // exclude from Solution build
        var oSolBuild = dte.Solution.SolutionBuild;
        var oSolConfigs = oSolBuild.SolutionConfigurations;
        for (var nCntr = 1; nCntr <= oSolConfigs.Count; nCntr++)
        {
            var oSolContexts = oSolConfigs(nCntr).SolutionContexts;
            for (var nCntr2 = 1; nCntr2 <= oSolContexts.Count; nCntr2++)
            {
                var oSolContext = oSolContexts(nCntr2);
                if (oSolContext.ProjectName == oProj.UniqueName)
                    oSolContext.ShouldBuild = false;
            }
        }

        // add main project to build dependency list
        oSolBuild.BuildDependencies(oProj.UniqueName).AddProject(oMainProj.UniqueName);

        StampWindowsTargetPlatformVersion(oProj)
    }
    catch(e)
    {
        throw e;
    }
}


function AddConfigurations(proj, strProjectName)
{
    try
    {
        var oConfigs = proj.Object.Configurations;
        for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++) {
            var config = oConfigs(nCntr);
            var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
            // check if Debug
            var bDebug = false;
            if (config.ConfigurationName === 'Debug')
                bDebug = true;

            // set configuration type
            var bAppTypeDLL = wizard.FindSymbol("DLL_APP");
            if (bAppTypeDLL)
                config.ConfigurationType = typeDynamicLibrary;

            config.CharacterSet = charSetUNICODE;

            // Compiler settings
            var CLTool = config.Tools("VCCLCompilerTool");
            CLTool.UsePrecompiledHeader = pchUseUsingSpecific;
            CLTool.WarningLevel = WarningLevel_3;
            if (bDebug)
            {
                CLTool.Optimization = optimizeDisabled;
            }
            else
            {
                CLTool.Optimization = optimizeMaxSpeed;
            }

            var bMFC = wizard.FindSymbol("SUPPORT_MFC");
            var bMergeProxy = wizard.FindSymbol("MERGE_PROXY_STUB");
            var bSupportComPlus = wizard.FindSymbol("SUPPORT_COMPLUS");
            var bSupportComponentRegistrar = wizard.FindSymbol("SUPPORT_COMPONENT_REGISTRAR");

            var strDefines = CLTool.PreprocessorDefinitions;
            if (strDefines != "") strDefines += ";";
            strDefines += GetPlatformDefine(config);
            strDefines += ";_WINDOWS"

            if (bDebug)
                strDefines += ";_DEBUG";
            else
                strDefines += ";NDEBUG";

            if (bAppTypeDLL)
                strDefines += ";_USRDLL";
            if (bMFC)
                config.UseOfMFC = useMfcDynamic;
            if (bMergeProxy && bSupportComponentRegistrar)
                strDefines += ";_MERGE_PROXYSTUB";
            CLTool.PreprocessorDefinitions = strDefines;

            // MIDL settings
            var MidlTool = config.Tools("VCMidlTool");
            MidlTool.MkTypLibCompatible = false;
            if (IsPlatformWin32(config))
                MidlTool.TargetEnvironment = midlTargetWin32;

            if (bDebug)
                MidlTool.PreprocessorDefinitions = "_DEBUG";
            else
                MidlTool.PreprocessorDefinitions = "NDEBUG";

            MidlTool.HeaderFileName = strIdlName + "_i.h";
            MidlTool.InterfaceIdentifierFileName = strIdlName + "_i.c";
            MidlTool.ProxyFileName = strIdlName + "_p.c";
            MidlTool.GenerateStublessProxies = true;
            MidlTool.TypeLibraryName = "$(IntDir)" + strIdlName + ".tlb";
            MidlTool.DLLDataFileName = "";

            // no /no_robust
            MidlTool.ValidateParameters = true;

            // Resource settings
            var RCTool = config.Tools("VCResourceCompilerTool");
            RCTool.Culture = wizard.FindSymbol("LCID");
            RCTool.AdditionalIncludeDirectories = "$(IntDir)";
            if (bDebug)
                RCTool.PreprocessorDefinitions = "_DEBUG";
            else
                RCTool.PreprocessorDefinitions = "NDEBUG";

            // Linker settings
            var LinkTool = config.Tools("VCLinkerTool");
            LinkTool.SubSystem = subSystemWindows;
            LinkTool.IgnoreImportLibrary = true;

            if (bAppTypeDLL)
            {
                var strDefFile = ".\\" + strProjectName + ".def";
                LinkTool.ModuleDefinitionFile = strDefFile;
            }
            if (bSupportComPlus)
                LinkTool.AdditionalDependencies += " comsvcs.lib";

            if (bDebug)
                LinkTool.LinkIncremental = linkIncrementalYes;
            else
            {
                LinkTool.LinkIncremental = linkIncrementalNo;
                LinkTool.EnableCOMDATFolding = optFolding;
                LinkTool.OptimizeReferences = optReferences;
            }


            LinkTool.RegisterOutput = true;

            if (bAppTypeDLL)
            {
                if (wizard.FindSymbol("SEARCH_HANDLER"))
                {
                    var PostBuildTool = config.Tools("VCPostBuildEventTool");
                    var L_SettingPermissions_Text = "ô DLL Ȩ( SearchFilterHost.exe )...";

                    var strGroupName = "";
                    // Get the localized name of the group "Users" using WMI
                    var oWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}");
                    var oResultSet = oWMIService.ExecQuery("Select * from Win32_Group Where LocalAccount = TRUE And SID = 'S-1-5-32-545'");
                    var resultEnumerator = new Enumerator(oResultSet);
                    if (!resultEnumerator.atEnd())
                    {
                        var oGroup = resultEnumerator.item();
                        strGroupName = oGroup.Name;
                        PostBuildTool.CommandLine = "cacls.exe \"$(TargetPath)\" /G " + strGroupName + ":r /E";
                    }
                    else
                    {
                        var L_SettingPermissionsFailure_Text = "޷ô DLL Ȩ( SearchFilterHost.exe )";
                        wizard.ReportError(L_SettingPermissionsFailure_Text);
                    }
                }
            }
        }
    }
    catch(e)
    {
        throw e;
    }
}

function SetPchSettings(proj, strProjectName)
{
    try
    {
        var files = proj.Object.Files;
        var fStdafxConfig = files("StdAfx.cpp").FileConfigurations;

        for (var nCntr = 1; nCntr <= fStdafxConfig.Count; nCntr++)
        {
            var config = fStdafxConfig(nCntr);
            config.Tool.UsePrecompiledHeader = pchCreateUsingSpecific;

            var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
            var fProject_i = files(strIdlName + "_i.c");
            config = fProject_i.FileConfigurations(nCntr);
            config.Tool.UsePrecompiledHeader = pchNone;

            if (wizard.FindSymbol("MERGE_PROXY_STUB"))
            {
                file = files("xdlldata.c");
                config = file.FileConfigurations(nCntr);
                config.Tool.UsePrecompiledHeader = pchNone;
            }
        }
    }
    catch(e)
    {
        throw e;
    }
}

// SIG // Begin signature block
// SIG // MIIj/AYJKoZIhvcNAQcCoIIj7TCCI+kCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 3lCnkfxTOIu7LEfflXX3CiMXDmQCiWnX/QDKGkNtZg+g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcEwghW9AgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggawwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIEYvnJtjaQpP5X/lwkfTEzl+7gnWc7ZfzkkKxBKt
// SIG // bqApMEAGCisGAQQBgjcCAQwxMjAwoBaAFABkAGUAZgBh
// SIG // AHUAbAB0AC4AagBzoRaAFGh0dHA6Ly9taWNyb3NvZnQu
// SIG // Y29tMA0GCSqGSIb3DQEBAQUABIIBADZR9b2+/d5QviP6
// SIG // BvigOdC+xxlfC3su7io6rIq1Cc2/Yw9JlznfQkqlTKWr
// SIG // X6tXyOCy3Zv7FZzgW3ZHBBp/EqWSusvcgGOZ9N7cdvyz
// SIG // YxuM3AoM2w9b08TM81bl/8ND++2DUEGeGQQkZrHxBH/0
// SIG // /6FxFeolPPibJVAJ21fqPHfjXS+4SR7hapQHaASct2b/
// SIG // wCq4rSf5iew0u+LmFZOYAXrQJ94nr6lsSu5z+r6KBkeB
// SIG // L13COksc2kutYRPgzTlZrM/mn9sZbYFO1RdZZ2tK3U8d
// SIG // bUXbEoqrWBpDPcLn2dzTYQh6PFUAIAMF2Xf/m2ngGlmt
// SIG // W9G1RJF9BHJDxbQyS0WhghNNMIITSQYKKwYBBAGCNwMD
// SIG // ATGCEzkwghM1BgkqhkiG9w0BBwKgghMmMIITIgIBAzEP
// SIG // MA0GCWCGSAFlAwQCAQUAMIIBPQYLKoZIhvcNAQkQAQSg
// SIG // ggEsBIIBKDCCASQCAQEGCisGAQQBhFkKAwEwMTANBglg
// SIG // hkgBZQMEAgEFAAQgfs0Zo0/fZ1OFMospOdKXM/6lSftQ
// SIG // 0Fk9BnP+jB29+hkCBliLkcN7YBgTMjAxNzAyMDkwNDE5
// SIG // MTkuNjEzWjAHAgEBgAIB9KCBuaSBtjCBszELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUGA1UE
// SIG // CxMebkNpcGhlciBEU0UgRVNOOkIxQjctRjY3Ri1GRUMy
// SIG // MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBT
// SIG // ZXJ2aWNloIIO0DCCBnEwggRZoAMCAQICCmEJgSoAAAAA
// SIG // AAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBSb290IENl
// SIG // cnRpZmljYXRlIEF1dGhvcml0eSAyMDEwMB4XDTEwMDcw
// SIG // MTIxMzY1NVoXDTI1MDcwMTIxNDY1NVowfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTAwggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQCpHQ28dxGKOiDs/BOX9fp/
// SIG // aZRrdFQQ1aUKAIKF++18aEssX8XD5WHCdrc+Zitb8BVT
// SIG // JwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCIhFRDDNdNuDgI
// SIG // s0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAyWGBG8lhHhjKE
// SIG // HnRhZ5FfgVSxz5NMksHEpl3RYRNuKMYa+YaAu99h/EbB
// SIG // Jx0kZxJyGiGKr0tkiVBisV39dx898Fd1rL2KQk1AUdEP
// SIG // nAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6Kgox8NpOBpG2
// SIG // iAg16HgcsOmZzTznL0S6p/TcZL2kAcEgCZN4zfy8wMlE
// SIG // XV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQBgkrBgEEAYI3
// SIG // FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIoxkPNDe3xGG8Uz
// SIG // aFqFbVUwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // CwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHwYD
// SIG // VR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186aGMQwVgYD
// SIG // VR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljUm9vQ2Vy
// SIG // QXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUFBwEBBE4w
// SIG // TDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSBlTCBkjCBjwYJ
// SIG // KwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIBFjFodHRwOi8v
// SIG // d3d3Lm1pY3Jvc29mdC5jb20vUEtJL2RvY3MvQ1BTL2Rl
// SIG // ZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQAH5ohR
// SIG // DeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F4qn++ldtGTCz
// SIG // wsVmyWrf9efweL3HqJ4l4/m87WtUVwgrUYJEEvu5U4zM
// SIG // 9GASinbMQEBBm9xcF/9c+V4XNZgkVkt070IQyK+/f8Z/
// SIG // 8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmptWvkx872ynoA
// SIG // b0swRCQiPM/tA6WWj1kpvLb9BOFwnzJKJ/1Vry/+tuWO
// SIG // M7tiX5rbV0Dp8c6ZZpCM/2pif93FSguRJuI57BlKcWOd
// SIG // eyFtw5yjojz6f32WapB4pm3S4Zz5Hfw42JT0xqUKloak
// SIG // vZ4argRCg7i1gJsiOCC1JeVk7Pf0v35jWSUPei45V3ai
// SIG // caoGig+JFrphpxHLmtgOR5qAxdDNp9DvfYPw4TtxCd9d
// SIG // dJgiCGHasFAeb73x4QDf5zEHpJM692VHeOj4qEir995y
// SIG // fmFrb3epgcunCaw5u+zGy9iCtHLNHfS4hQEegPsbiSpU
// SIG // ObJb2sgNVZl6h3M7COaYLeqN4DMuEin1wC9UJyH3yKxO
// SIG // 2ii4sanblrKnQqLJzxlBTeCG+SqaoxFmMNO7dDJL32N7
// SIG // 9ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp3lfB0d4wwP3M
// SIG // 5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa7wknHNWzfjUe
// SIG // CLraNtvTX4/edIhJEjCCBNowggPCoAMCAQICEzMAAACx
// SIG // cRN533X2NcgAAAAAALEwDQYJKoZIhvcNAQELBQAwfDEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcNMTYwOTA3
// SIG // MTc1NjU3WhcNMTgwOTA3MTc1NjU3WjCBszELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUGA1UE
// SIG // CxMebkNpcGhlciBEU0UgRVNOOkIxQjctRjY3Ri1GRUMy
// SIG // MSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBT
// SIG // ZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
// SIG // CgKCAQEAqqQklG1Y1lu8ob0P7deumuRn4JvRi2GErmK9
// SIG // 4vgbnWPmd0j/9arA7539HD1dpG1uhYbmnAxc+qsuvMM0
// SIG // fpEvttTK4lZSU7ss5rJfWmbFn/J8kSGI8K9iBaB6hQkJ
// SIG // uIX4si9ppNr9R3oZI3HbJ/yRkKUPk4hozpY6CkehRc0/
// SIG // Zfu6tQiyqI7mClXYZTXjw+rLsh3/gdBvYDd38zFBllaf
// SIG // +3uimKQgUTXGjbKfqZZk3tEU3ibWVPUxAmmxlG3sWTlX
// SIG // mU31fCw/6TVzGg251lq+Q46OjbeH9vB2TOcqEso4Nai3
// SIG // J1CdMAYUdlelVVtgQdIx/c+5Hvrw0Y6W7uGBAWnW5wID
// SIG // AQABo4IBGzCCARcwHQYDVR0OBBYEFE5XPfeLLhRLV7L8
// SIG // Il7Tz7cnRBA7MB8GA1UdIwQYMBaAFNVjOlyKMZDzQ3t8
// SIG // RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6
// SIG // Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1
// SIG // Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNybDBa
// SIG // BggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6
// SIG // Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWlj
// SIG // VGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDQYJKoZI
// SIG // hvcNAQELBQADggEBAHPujfu0W8PBTpjfYaPrAKIBLKcl
// SIG // jT4+YnWbbgGvmXU8OvIUDBkkv8gNGGHRO5DSySaCARIz
// SIG // gn2yIheAqh6GwM2yKrfb4eVCYPe1CTlCseS5TOv+Tn/9
// SIG // 5mXj+NxTqvuNmrhgCVr0CQ7b3xoKcwDcQbg7TmerDgbI
// SIG // v2k7cEqbYbU/B3MtSX8Zjjf0ZngdKoX0JYkAEDbZchOr
// SIG // RiUtDJItegPKZPf6CjeHYjrmKwvTOVCzv3lW0uyh1yb/
// SIG // ODeRH+VqENSHCboFiEiq9KpKMOpek1VvQhmI2KbTlRvK
// SIG // 869gj1NwuUHH8c3WXu4A0X1+CBmU8t0gvd/fFlQvw04v
// SIG // eKWh986hggN5MIICYQIBATCB46GBuaSBtjCBszELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUG
// SIG // A1UECxMebkNpcGhlciBEU0UgRVNOOkIxQjctRjY3Ri1G
// SIG // RUMyMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoFAAMVADq635Mo
// SIG // ZeR60+ej9uKnRG5YqlPSoIHCMIG/pIG8MIG5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYD
// SIG // VQQLEx5uQ2lwaGVyIE5UUyBFU046NERFOS0wQzVFLTNF
// SIG // MDkxKzApBgNVBAMTIk1pY3Jvc29mdCBUaW1lIFNvdXJj
// SIG // ZSBNYXN0ZXIgQ2xvY2swDQYJKoZIhvcNAQEFBQACBQDc
// SIG // Rcx0MCIYDzIwMTcwMjA4MTY1NzI0WhgPMjAxNzAyMDkx
// SIG // NjU3MjRaMHcwPQYKKwYBBAGEWQoEATEvMC0wCgIFANxF
// SIG // zHQCAQAwCgIBAAICFNMCAf8wBwIBAAICGzowCgIFANxH
// SIG // HfQCAQAwNgYKKwYBBAGEWQoEAjEoMCYwDAYKKwYBBAGE
// SIG // WQoDAaAKMAgCAQACAxbjYKEKMAgCAQACAwehIDANBgkq
// SIG // hkiG9w0BAQUFAAOCAQEAWIKmDsYY8xR83ysOf8gLkm/i
// SIG // hA2LR7qAsCieKFoosIzEsFlYXWDwGFIcqFMu64DCZydr
// SIG // f0NGs5EQutt+YdRkqoDwpyFo1rUo7/XVkUdLcIJlxErv
// SIG // sfyhqrNdwAlQ2bKS+z1RyqD49N+yBWo8pgI7G8mEbvC5
// SIG // UCNy6EWf3I1mq9i86oMUtcs4Z9uvZdSZ3ifkaxjvtljl
// SIG // Qzfqo7UMy1bdbWyVZE4FQNA8aKdN4RZNNQj6TpR0vxBn
// SIG // pTdfGt9BmMww/AYRhEqkK0D6i95DPCHLWkhhGxjXqW5q
// SIG // a7yhKWoMgJpe1ZkF4vmktdH+72BaH4E8qSFqxqYwMa/A
// SIG // 0ll9GPGv5zGCAvUwggLxAgEBMIGTMHwxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFBDQSAyMDEwAhMzAAAAsXETed919jXIAAAA
// SIG // AACxMA0GCWCGSAFlAwQCAQUAoIIBMjAaBgkqhkiG9w0B
// SIG // CQMxDQYLKoZIhvcNAQkQAQQwLwYJKoZIhvcNAQkEMSIE
// SIG // IKZwc15jm/MCgVw/v25UYexq10gO5/qgppC/9LUmvxpT
// SIG // MIHiBgsqhkiG9w0BCRACDDGB0jCBzzCBzDCBsQQUOrrf
// SIG // kyhl5HrT56P24qdEbliqU9IwgZgwgYCkfjB8MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAALFxE3nfdfY1
// SIG // yAAAAAAAsTAWBBRWFy9wpUmQx/y5g8QQXsyqOirhBzAN
// SIG // BgkqhkiG9w0BAQsFAASCAQBe4cS2jeoRSlmkSiiH6Pe6
// SIG // 6kN6p2HddM/VPJIXPADx9juK0RHvz1AI0yfkdS3p8zVV
// SIG // qkGoDqHx3JLgVboXTUA+E4i6Z7q6lF42iiMp3dB7xsQ/
// SIG // uiG3ym5rIqK3FJ3YtjTMY+tclGuA2SxZGf1unrOD/+SU
// SIG // TSV+2sKuFYzk4thjObdNpy9QbuToGBKmfM+OGdBSq1j/
// SIG // qUGFzD5onex07fmlHinpfXSLLPQYZ89HvQ0l5n5XJ+Ji
// SIG // pSqep+99/woHemmJDjUs4ns8sjCoWkn7t6p2HffFA0HX
// SIG // DinlVMqD+5FfDF/fQYJkg2nM5ouVBFpKv1R5nnoeRSuZ
// SIG // yVdSruK9hG/o
// SIG // End signature block
